package fr.asip.cps3.exemple.modele.resultats;

import java.util.LinkedHashMap;

/**
 * Classe reprsentant le rsultat d'une opration accompagn d'informations
 */
public class ResultatInfo extends Resultat {

	/**
	 * Map d'informations
	 */
	protected LinkedHashMap<String,String> infos = new LinkedHashMap<String,String>();

	/**
	 * Constructeur
	 * @param operation L'opration
	 */
	public ResultatInfo(String operation){
		super(operation);
	}
	
	/**
	 * Accesseur
	 * @return La map d'informations
	 */
	public LinkedHashMap<String,String> getInfos() {
		return this.infos;
	}

	/**
	 * Mutateur
	 * @param infos Map d'informations
	 */
	public void setInfos(LinkedHashMap<String,String> infos) {
		this.infos = infos;
	}

}
